<div id="projects" class="section-projects-1 position-relative pt-120 pb-6 bg-900">
    <div class="container">
        <div class="row align-items-end">
            <?php if($shortcode->title || $shortcode->subtitle): ?>
                <div class="col-lg-7 me-auto">
                    <?php if($shortcode->title): ?>
                        <h3 class="ds-3 mt-3 mb-3 text-primary"><?php echo BaseHelper::clean($shortcode->title); ?></h3>
                    <?php endif; ?>
                    <?php if($shortcode->subtitle): ?>
                        <span class="fs-5 fw-medium text-200">
                        <?php echo BaseHelper::clean(nl2br($shortcode->subtitle)); ?>

                    </span>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <?php if($shortcode->action_text): ?>
                <div class="col-lg-auto">
                    <a href="<?php echo e($shortcode->action_link); ?>" class="btn btn-gradient mt-lg-0 mt-5 ms-lg-auto d-none d-xl-block">
                        <?php echo e($shortcode->action_text); ?>

                        <i class="ri-arrow-right-up-line"></i>
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<div
    class="bg-900 fillter-project"
    <?php if($shortcode->background_image): ?>
        data-background="<?php echo e(RvMedia::getImageUrl($shortcode->background_image)); ?>"
    <?php endif; ?>
>
    <div class="container">
        <div class="text-start">
            <div class="button-group filter-button-group filter-menu-active">
                <button class="btn btn-md btn-filter mb-2 me-2 text-uppercase active" data-filter="*"><?php echo e(__('All Projects')); ?></button>
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <button class="btn btn-md btn-filter mb-2 me-2 text-uppercase" data-filter=".<?php echo e(Str::slug($category->name)); ?>"><?php echo e($category->name); ?></button>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <div class="row masonry-active justify-content-between mt-6">
            <div class="grid-sizer"></div>
            <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['filter-item col-lg-6 col-12', $project->categories->pluck('name')->map(fn ($name) => Str::slug($name))->join(' ')]); ?>">
                    <div class="project-item rounded-4 overflow-hidden position-relative p-md-4 p-3 bg-white">
                        <?php if($project->image): ?>
                            <a href="<?php echo e($project->url); ?>">
                                <?php echo e(RvMedia::image($project->image, $project->name, attributes: ['class' => 'rounded-3 w-100 zoom-img'])); ?>

                            </a>
                        <?php endif; ?>
                        <div class="d-flex align-items-center mt-4">
                            <a href="<?php echo e($project->url); ?>" class="project-card-content">
                                <h3 class="fw-semibold">
                                    <?php echo BaseHelper::clean($project->name); ?>

                                </h3>
                                <?php if($project->client): ?>
                                    <p><?php echo e($project->client); ?></p>
                                <?php endif; ?>
                            </a>
                            <a href="<?php echo e($project->url); ?>" title="<?php echo e($project->name); ?>" class="project-card-icon icon-shape ms-auto icon-md rounded-circle">
                                <i class="ri-arrow-right-up-line"></i>
                            </a>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>

<div class="contairer overflow-hidden">
    <div class="row justify-content-center position-relative button-project pb-160 bg-900 pt-1">
        <?php if($shortcode->bottom_action_text): ?>
            <a href="<?php echo e($shortcode->bottom_action_link); ?>" class="icon_hover position-relative z-1 icon-shape icon_150 border-linear-2 rounded-circle position-relative overflow-hidden bg-white hover-up">
                <span class="icon-shape icon-md bg-linear-2 rounded-circle position-absolute bottom-0 end-0"></span>
                <p class="m-0 fs-7 fw-bold text-capitalize position-absolute top-50 start-50 translate-middle">
                    <?php echo e($shortcode->bottom_action_text); ?>

                    <i class="ri-arrow-right-up-line fs-7"></i>
                </p>
            </a>
        <?php endif; ?>
        <div class="ellipse position-absolute bottom-0 start-50 translate-middle-x z-0"></div>
    </div>
</div>
<?php /**PATH /home/bangla34/SadikHossain/platform/themes/zelio/partials/shortcodes/projects/styles/style-1.blade.php ENDPATH**/ ?>