<section class="section-work-single section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-lg-auto mb-lg-0">
                <div class="text-center">
                    <div class="btn btn-gradient d-inline-block text-uppercase"><?php echo e(__('Project')); ?></div>
                    <h3 class="ds-3 mt-3 mb-4 text-dark"><?php echo BaseHelper::clean($project->name); ?></h3>
                    <p class="text-300 fs-5 mb-0"><?php echo BaseHelper::clean(nl2br($project->description)); ?></p>
                </div>
            </div>
            <div class="d-flex flex-wrap justify-content-center gap-4 py-8">
                <div class="bg-6 px-5 py-3 rounded-2">
                    <p class="text-300 mb-0"><?php echo e(__('Client')); ?></p>
                    <h6><?php echo e($project->client); ?></h6>
                </div>
                <?php if($project->start_date): ?>
                    <div class="bg-6 px-5 py-3 rounded-2">
                        <p class="text-300 mb-0"><?php echo e(__('Start Date')); ?></p>
                        <h6><?php echo e(Theme::formatDate($project->start_date)); ?></h6>
                    </div>
                <?php endif; ?>
                <?php if($project->category): ?>
                    <div class="bg-6 px-5 py-3 rounded-2">
                        <p class="text-300 mb-0"><?php echo e(__('Category')); ?></p>
                        <h6><a href="<?php echo e($project->category->url); ?>"><?php echo e($project->category->name); ?></a></h6>
                    </div>
                <?php endif; ?>
                <?php if($project->author): ?>
                    <div class="bg-6 px-5 py-3 rounded-2">
                        <p class="text-300 mb-0"><?php echo e(__('Author')); ?></p>
                        <h6><?php echo e($project->author); ?></h6>
                    </div>
                <?php endif; ?>
                <?php if($project->place): ?>
                    <div class="bg-6 px-5 py-3 rounded-2">
                        <p class="text-300 mb-0"><?php echo e(__('Place')); ?></p>
                        <h6><?php echo e($project->place); ?></h6>
                    </div>
                <?php endif; ?>
                <?php if($link = $project->getMetaData('link', true)): ?>
                    <div class="bg-6 px-5 py-3 rounded-2">
                        <p class="text-300 mb-0"><?php echo e(__('Website')); ?></p>
                        <h6>
                            <a href="<?php echo e($link); ?>" target="_blank"  class="d-flex align-items-center gap-2">
                                <?php echo e(__('Visit Website')); ?>

                                <?php if (isset($component)) { $__componentOriginal73995948b3bd877b76251b40caf28170 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal73995948b3bd877b76251b40caf28170 = $attributes; } ?>
<?php $component = Botble\Icon\View\Components\Icon::resolve(['name' => 'ti ti-external-link'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('core::icon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Botble\Icon\View\Components\Icon::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $attributes = $__attributesOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__attributesOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $component = $__componentOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__componentOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
                            </a>
                        </h6>
                    </div>
                <?php endif; ?>
            </div>
            <?php if($project->image): ?>
                <?php echo e(RvMedia::image($project->image, $project->name)); ?>

            <?php endif; ?>
            <div class="col-lg-8 mx-lg-auto mt-8">
                <div class="ck-content"><?php echo BaseHelper::clean($project->content); ?></div>
                <div class="border-linear-3 rounded-4 p-lg-6 p-md-4 p-3 my-4">
                    <span class="text-uppercase fs-7"><?php echo e(__('Share')); ?></span> <br />
                    <?php echo Theme::renderSocialSharing($project->url, SeoHelper::getDescription(), $project->image); ?>

                </div>
                <?php echo apply_filters(BASE_FILTER_PUBLIC_COMMENT_AREA, null, $project); ?>

            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/bangla34/SadikHossain/platform/themes/zelio/views/portfolio/project.blade.php ENDPATH**/ ?>