<section
    id="resume"
    class="section-resume-1 position-relative pt-150 overflow-hidden"
    <?php if($shortcode->background_image): ?>
        data-background="<?php echo e(RvMedia::getImageUrl($shortcode->background_image)); ?>"
    <?php endif; ?>
>
    <div class="container">
        <?php if($shortcode->title || $shortcode->subtitle || $shortcode->action_text): ?>
            <div class="row align-items-end">
                <?php if($shortcode->title || $shortcode->subtitle): ?>
                    <div class="col-lg-7 me-auto">
                        <?php if($shortcode->title): ?>
                            <h3 class="ds-3 mt-3 mb-3 text-primary"><?php echo BaseHelper::clean($shortcode->title); ?></h3>
                        <?php endif; ?>
                        <?php if($shortcode->subtitle): ?>
                            <span class="fs-5 fw-medium text-200">
                                <?php echo BaseHelper::clean(nl2br($shortcode->subtitle)); ?>

                            </span>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
                <?php if($shortcode->action_text): ?>
                    <div class="col-lg-auto">
                        <a href="<?php echo e($shortcode->action_link); ?>" class="btn btn-gradient mt-lg-0 mt-5 ms-lg-auto">
                            <?php echo BaseHelper::clean($shortcode->action_text); ?>

                            <i class="ri-arrow-right-up-line"></i>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['row mt-6 row-cols-1', 'row-cols-lg-1' => count($resumes) === 1, 'row-cols-lg-2' => count($resumes) > 1]); ?>">
            <?php $__currentLoopData = $resumes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $resume): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $iconKey = "resume_{$loop->iteration}_title_icon";
                    $titleKey = "resume_{$loop->iteration}_title";
                ?>
                <div class="col">
                    <div class="resume-card p-lg-6 p-4 mb-lg-0 mb-6">
                        <div class="resume-card-header d-flex align-items-end">
                            <?php if (isset($component)) { $__componentOriginal73995948b3bd877b76251b40caf28170 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal73995948b3bd877b76251b40caf28170 = $attributes; } ?>
<?php $component = Botble\Icon\View\Components\Icon::resolve(['name' => $shortcode->{$iconKey}] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('core::icon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Botble\Icon\View\Components\Icon::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'border-linear-1 border-3 pb-2 pe-2']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $attributes = $__attributesOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__attributesOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $component = $__componentOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__componentOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
                            <h3 class="fw-semibold mb-0 border-bottom border-600 border-3 pb-2 w-100">
                                <?php echo BaseHelper::clean($shortcode->{$titleKey}); ?>

                            </h3>
                        </div>
                        <div class="resume-card-body">
                            <?php $__currentLoopData = $resume; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="resume-card-item px-4 py-3 mt-5">
                                    <div class="d-flex align-items-end">
                                        <div>
                                            <?php if($item['time']): ?>
                                                <p class="fw-extra-bold text-linear-1 mb-2"><?php echo e($item['time']); ?></p>
                                            <?php endif; ?>
                                            <?php if($item['title']): ?>
                                                <h5><?php echo e($item['title']); ?></h5>
                                            <?php endif; ?>
                                            <?php if($item['description']): ?>
                                                <p class="text-300 mb-0"><?php echo e($item['description']); ?></p>
                                            <?php endif; ?>
                                        </div>
                                        <?php
                                            $rating = explode('/', $item['subtitle']);

                                            $total = count($rating) > 1 ? $rating[1] : null;
                                            $rating = $rating[0];
                                        ?>
                                        <h3 class="text-linear-1 ms-auto fw-semibold">
                                            <?php echo e($rating); ?><?php if($total): ?><span class="fs-4 fw-bold">/<?php echo e($total); ?></span><?php endif; ?>
                                        </h3>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['scroll-move-right position-relative', 'pb-160 pt-lg-150' => $shortcode->bottom_text, 'pt-150' => ! $shortcode->bottom_text]); ?>">
        <?php if($shortcode->bottom_text): ?>
            <div class="d-flex align-items-center gap-5 wow img-custom-anim-top position-absolute top-50 start-50 translate-middle">
                <h3 class="stroke fs-150 text-uppercase text-white"><?php echo BaseHelper::clean($shortcode->bottom_text); ?></h3>
            </div>
        <?php endif; ?>
    </div>
</section>
<?php /**PATH /home/bangla34/SadikHossain/platform/themes/zelio/partials/shortcodes/resume/styles/style-1.blade.php ENDPATH**/ ?>