<?php if($paginator->hasPages()): ?>
    <nav class="d-flex justify-content-center align-items-center">
        <div>
            <ul class="pagination gap-2">
                
                <?php if($paginator->onFirstPage()): ?>
                    <li class="page-item disabled" aria-disabled="true" aria-label="<?php echo app('translator')->get('pagination.previous'); ?>">
                        <span class="icon-xl fs-5 page-link pagination_item border-0 rounded-circle icon-shape fw-bold bg-600" aria-hidden="true">
                            <i class="ri-arrow-left-line"></i>
                        </span>
                    </li>
                <?php else: ?>
                    <li class="page-item">
                        <a class="icon-xl fs-5 page-link pagination_item border-0 rounded-circle icon-shape fw-bold bg-600" href="<?php echo e($paginator->previousPageUrl()); ?>" rel="prev" aria-label="<?php echo app('translator')->get('pagination.previous'); ?>">
                            <i class="ri-arrow-left-line"></i>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php $__currentLoopData = $elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    
                    <?php if(is_string($element)): ?>
                        <li class="page-item disabled" aria-disabled="true"><span class="icon-xl fs-5 page-link pagination_item border-0 rounded-circle icon-shape fw-bold bg-600"><?php echo e($element); ?></span></li>
                    <?php endif; ?>

                    
                    <?php if(is_array($element)): ?>
                        <?php $__currentLoopData = $element; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($page == $paginator->currentPage()): ?>
                                <li class="page-item active" aria-current="page"><span class="icon-xl fs-5 page-link pagination_item border-0 rounded-circle icon-shape fw-bold bg-600"><?php echo e($page); ?></span></li>
                            <?php else: ?>
                                <li class="page-item"><a class="icon-xl fs-5 page-link pagination_item border-0 rounded-circle icon-shape fw-bold bg-600" href="<?php echo e($url); ?>"><?php echo e($page); ?></a></li>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                
                <?php if($paginator->hasMorePages()): ?>
                    <li class="page-item">
                        <a class="icon-xl fs-5 page-link pagination_item border-0 rounded-circle icon-shape fw-bold bg-600" href="<?php echo e($paginator->nextPageUrl()); ?>" rel="next" aria-label="<?php echo app('translator')->get('pagination.next'); ?>">
                            <i class="ri-arrow-right-line"></i>
                        </a>
                    </li>
                <?php else: ?>
                    <li class="page-item disabled" aria-disabled="true" aria-label="<?php echo app('translator')->get('pagination.next'); ?>">
                        <span class="icon-xl fs-5 page-link pagination_item border-0 rounded-circle icon-shape fw-bold bg-600" aria-hidden="true">
                            <i class="ri-arrow-right-line"></i>
                        </span>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </nav>
<?php endif; ?>
<?php /**PATH /home/bangla34/SadikHossain/platform/themes/zelio/partials/pagination.blade.php ENDPATH**/ ?>